/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.data.DataAI;

public class SubGuiNpcMovement
extends SubGuiInterface
implements ITextfieldListener {
    private static final String[] walkingTypes = new String[]{"ai.standing", "ai.wandering", "ai.movingpath"};
    private static final String[] navigationTypes = new String[]{"movement.ground", "movement.flying", "movement.swimming"};
    private static final String[] animationTypes = new String[]{"stats.normal", "movement.sitting", "movement.lying", "movement.hug", "movement.sneaking", "movement.dancing", "movement.aiming", "movement.crawling"};
    private static final String[] rotationTypes = new String[]{"movement.body", "movement.manual", "movement.stalking", "movement.head", "movement.stalking.2"};
    private final DataAI ai;

    public SubGuiNpcMovement(DataAI ais) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.ai = ais;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.ai.setMovingType(button.getValue());
                if (this.ai.getMovingType() != 0) {
                    float f;
                    this.ai.animationType = 0;
                    this.ai.setStandingType(0);
                    this.ai.bodyOffsetZ = f = 5.0f;
                    this.ai.bodyOffsetY = f;
                    this.ai.bodyOffsetX = f;
                }
                this.func_73866_w_();
                break;
            }
            case 2: {
                this.ai.movingPause = button.getValue() == 1;
                break;
            }
            case 4: {
                this.ai.setAnimation(button.getValue());
                this.func_73866_w_();
                break;
            }
            case 5: {
                this.ai.npcInteracting = button.getValue() == 1;
                break;
            }
            case 7: {
                this.ai.setStandingType(button.getValue());
                this.func_73866_w_();
                break;
            }
            case 8: {
                this.ai.movingPattern = button.getValue();
                break;
            }
            case 13: {
                this.ai.stopAndInteract = button.getValue() == 1;
                break;
            }
            case 15: {
                this.ai.movementType = button.getValue();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        GuiNpcTextField textField;
        super.func_73866_w_();
        int y = this.guiTop + 4;
        int lId = 0;
        this.addLabel(new GuiNpcLabel(lId++, "movement.type", this.guiLeft + 4, y + 5));
        GuiNpcButton button = new GuiNpcButton(0, this.guiLeft + 80, y, 100, 20, walkingTypes, this.ai.getMovingType());
        button.setHoverText("ai.hover.walking.type", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(15, this.guiLeft + 80, y += 22, 100, 20, navigationTypes, this.ai.movementType);
        button.setHoverText("ai.hover.walking", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "movement.navigation", this.guiLeft + 4, y + 5));
        if (this.ai.getMovingType() == 1) {
            textField = new GuiNpcTextField(4, this, this.guiLeft + 100, y += 22, 40, 20, this.ai.walkingRange + "");
            textField.setMinMaxDefault(0L, 1000L, 10L);
            textField.setHoverText("ai.hover.walking.range", new Object[0]);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(lId++, "gui.range", this.guiLeft + 4, y + 5));
            button = new GuiNpcButton(5, this.guiLeft + 100, y += 22, 50, 20, new String[]{"gui.no", "gui.yes"}, this.ai.npcInteracting ? 1 : 0);
            button.setHoverText("ai.hover.offset.r", new Object[0]);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(lId++, "movement.wanderinteract", this.guiLeft + 4, y + 5));
            button = new GuiNpcButton(2, this.guiLeft + 80, y += 22, 80, 20, new String[]{"gui.no", "gui.yes"}, this.ai.movingPause ? 1 : 0);
            button.setHoverText("ai.hover.offset.r", new Object[0]);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(lId++, "movement.pauses", this.guiLeft + 4, y + 5));
        } else if (this.ai.getMovingType() == 0) {
            this.addLabel(new GuiNpcLabel(lId++, "spawner.posoffset", this.guiLeft + 4, (y += 22) + 5));
            this.addLabel(new GuiNpcLabel(lId++, "X:", this.guiLeft + 115, y + 5));
            textField = new GuiNpcTextField(7, this, this.guiLeft + 99, y, 24, 20, this.ai.bodyOffsetX + "");
            textField.setMinMaxDoubleDefault(0.0, 10.0, 5.0);
            textField.setHoverText("ai.hover.offset.x", new Object[0]);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(lId++, "Y:", this.guiLeft + 125, y + 5));
            textField = new GuiNpcTextField(8, this, this.guiLeft + 135, y, 24, 20, this.ai.bodyOffsetY + "");
            textField.setMinMaxDoubleDefault(0.0, 10.0, 5.0);
            textField.setHoverText("ai.hover.offset.y", new Object[0]);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(lId++, "Z:", this.guiLeft + 161, y + 5));
            textField = new GuiNpcTextField(9, this, this.guiLeft + 171, y, 24, 20, this.ai.bodyOffsetZ + "");
            textField.setMinMaxDoubleDefault(0.0, 10.0, 5.0);
            textField.setHoverText("ai.hover.offset.z", new Object[0]);
            this.addTextField(textField);
            button = new GuiNpcButton(4, this.guiLeft + 80, y += 22, 100, 20, animationTypes, this.ai.animationType);
            button.setHoverText("ai.hover.walking.anim", new Object[0]);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(lId++, "movement.animation", this.guiLeft + 4, y + 5));
            if (this.ai.animationType != 2) {
                button = new GuiNpcButton(7, this.guiLeft + 80, y += 22, 80, 20, rotationTypes, this.ai.getStandingType());
                button.setHoverText("ai.hover.rotation", new Object[0]);
                this.addButton(button);
                this.addLabel(new GuiNpcLabel(lId++, "movement.rotation", this.guiLeft + 4, y + 5));
            } else {
                textField = new GuiNpcTextField(5, this, this.guiLeft + 99, y += 22, 40, 20, this.ai.orientation + "");
                textField.setMinMaxDefault(0L, 359L, 0L);
                textField.setHoverText("ai.hover.interact", new Object[0]);
                this.addTextField(textField);
                this.addLabel(new GuiNpcLabel(lId++, "movement.rotation", this.guiLeft + 4, y + 5));
                this.addLabel(new GuiNpcLabel(lId++, "(0-359)", this.guiLeft + 142, y + 5));
            }
            if (this.ai.getStandingType() == 1 || this.ai.getStandingType() == 3 || this.ai.getStandingType() == 4) {
                textField = new GuiNpcTextField(5, this, this.guiLeft + 165, y, 40, 20, this.ai.orientation + "");
                textField.setMinMaxDefault(0L, 359L, 0L);
                textField.setHoverText("ai.hover.interact", new Object[0]);
                this.addTextField(textField);
                this.addLabel(new GuiNpcLabel(lId++, "(0-359)", this.guiLeft + 207, y + 5));
            }
        }
        if (this.ai.getMovingType() != 0) {
            button = new GuiNpcButton(4, this.guiLeft + 80, y += 22, 100, 20, animationTypes, this.ai.animationType);
            button.setHoverText("ai.hover.walking.anim", new Object[0]);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(lId++, "movement.animation", this.guiLeft + 4, y + 5));
        }
        if (this.ai.getMovingType() == 2) {
            button = new GuiNpcButton(8, this.guiLeft + 80, y += 22, 80, 20, new String[]{"ai.looping", "ai.backtracking"}, this.ai.movingPattern);
            button.setHoverText("ai.hover.path.closed", new Object[0]);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(lId++, "movement.name", this.guiLeft + 4, y + 5));
            button = new GuiNpcButton(2, this.guiLeft + 80, y += 22, 80, 20, new String[]{"gui.no", "gui.yes"}, this.ai.movingPause ? 1 : 0);
            button.setHoverText("ai.hover.walking.stop", new Object[0]);
            this.addButton(button);
            this.addLabel(new GuiNpcLabel(lId++, "movement.pauses", this.guiLeft + 4, y + 5));
        }
        button = new GuiNpcButton(13, this.guiLeft + 100, y += 22, 50, 20, new String[]{"gui.no", "gui.yes"}, this.ai.stopAndInteract ? 1 : 0);
        button.setHoverText("ai.hover.stop.interact", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "movement.stopinteract", this.guiLeft + 4, y + 5));
        textField = new GuiNpcTextField(14, this, this.guiLeft + 80, y += 22, 50, 18, this.ai.getWalkingSpeed() + "");
        textField.setMinMaxDefault(0L, 10L, 4L);
        textField.setHoverText("ai.hover.walking.speed", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "stats.movespeed", this.guiLeft + 5, y + 5));
        textField = new GuiNpcTextField(15, this, this.guiLeft + 80, y += 22, 50, 18, this.ai.stepheight + "");
        textField.setMinMaxDoubleDefault(0.1, 3.0, this.ai.stepheight);
        textField.setHoverText("ai.hover.step.height", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId, "stats.stepheight", this.guiLeft + 5, y + 5));
        button = new GuiNpcButton(66, this.guiLeft + 190, this.guiTop + 190, 60, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        switch (textfield.getID()) {
            case 4: {
                this.ai.walkingRange = textfield.getInteger();
                break;
            }
            case 5: {
                this.ai.orientation = textfield.getInteger();
                this.npc.field_70177_z = textfield.getInteger();
                break;
            }
            case 7: {
                this.ai.bodyOffsetX = (float)((double)Math.round(textfield.getDouble() * 100.0) / 100.0);
                this.func_73866_w_();
                break;
            }
            case 8: {
                this.ai.bodyOffsetY = (float)((double)Math.round(textfield.getDouble() * 100.0) / 100.0);
                this.func_73866_w_();
                break;
            }
            case 9: {
                this.ai.bodyOffsetZ = (float)((double)Math.round(textfield.getDouble() * 100.0) / 100.0);
                this.func_73866_w_();
                break;
            }
            case 14: {
                this.ai.setWalkingSpeed(textfield.getInteger());
                break;
            }
            case 15: {
                this.ai.stepheight = (float)textfield.getDouble();
            }
        }
    }
}

